/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_591;
import net.minecraft.class_922;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class ClosestPlayerConstraint
implements VerletConstraint {
    private class_1657 player;
    private class_1937 level;
    private class_591<class_1657> model;
    private ModelCube[] modelCubes = new ModelCube[6];
    private VerletHelper helper = new VerletHelper();
    private double playerx;
    private double playery;
    private double playerz;
    private Vector3d invPoint = new Vector3d();
    private Matrix4d transform = new Matrix4d();
    private Matrix4d invTransform = new Matrix4d();
    private class_4587 modelMatrix = new class_4587();
    private Quaternionf tmpQuat = new Quaternionf();

    public ClosestPlayerConstraint(class_1937 level) {
        this.level = level;
        for (int i = 0; i < this.modelCubes.length; ++i) {
            this.modelCubes[i] = new ModelCube();
        }
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        Vector3d offset = simulation.getOffset();
        double px = offset.x;
        double py = offset.y;
        double pz = offset.z;
        if (simulation.getPoints().size() > 0) {
            Vector3d pos = simulation.getPoints().get((int)0).position;
            px += pos.x;
            py += pos.y;
            pz += pos.z;
        }
        this.player = this.level.method_18459(px, py, pz, 10.0, false);
        if (this.player != null) {
            int i;
            class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)this.player);
            this.model = (class_591)renderer.method_4038();
            this.modelCubes[0].part = this.model.field_3394;
            this.modelCubes[1].part = this.model.field_3391;
            this.modelCubes[2].part = this.model.field_3401;
            this.modelCubes[3].part = this.model.field_27433;
            this.modelCubes[4].part = this.model.field_3392;
            this.modelCubes[5].part = this.model.field_3397;
            for (i = 0; i < this.modelCubes.length; ++i) {
                this.modelCubes[i].pose = this.modelCubes[i].part.method_32084();
                this.modelCubes[i].updateHitbox();
            }
            this.modelMatrix.method_22903();
            this.setupModelAnimations(1.0f);
            this.playerTransformation(this.modelMatrix, simulation, this.player, 1.0f, 1.0f);
            for (i = 0; i < this.modelCubes.length; ++i) {
                ModelCube modelCube = this.modelCubes[i];
                Matrix4f currentPose = this.modelMatrix.method_23760().method_23761();
                modelCube.transform.set((Matrix4fc)currentPose);
                this.translateAndRotate(modelCube.transform, modelCube.pose);
            }
            this.modelMatrix.method_22909();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        for (int i = 0; i < this.modelCubes.length; ++i) {
            this.modelCubes[i].updateTransformation();
        }
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        if (this.player != null) {
            this.doCollisionCheck(percent, simulation);
        }
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    private void playerTransformation(class_4587 modelMatrix, VerletSimulation simulation, class_1657 player, float tickDelta, float animationProgress) {
        class_2350 direction;
        class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)player);
        this.playerx = class_3532.method_16436((double)tickDelta, (double)player.field_6038, (double)player.method_23317());
        this.playery = class_3532.method_16436((double)tickDelta, (double)player.field_5971, (double)player.method_23318());
        this.playerz = class_3532.method_16436((double)tickDelta, (double)player.field_5989, (double)player.method_23321());
        this.playerx -= simulation.getOffset().x;
        this.playery -= simulation.getOffset().y;
        this.playerz -= simulation.getOffset().z;
        class_243 positionOffset = renderer.method_23169((class_1297)player, tickDelta);
        modelMatrix.method_22904(positionOffset.field_1352 + this.playerx, positionOffset.field_1351 + this.playery, positionOffset.field_1350 + this.playerz);
        float yaw = class_3532.method_17821((float)tickDelta, (float)player.field_6220, (float)player.field_6283);
        if (player.method_18376() == class_4050.field_18078 && (direction = player.method_18401()) != null) {
            float eyeHeight = player.method_18381(class_4050.field_18076) - 0.1f;
            modelMatrix.method_22904((double)((float)(-direction.method_10148()) * eyeHeight), 0.0, (double)((float)(-direction.method_10165()) * eyeHeight));
        }
        renderer.method_4058((class_1309)player, modelMatrix, animationProgress, yaw, tickDelta, 1.0f);
        modelMatrix.method_22905(-1.0f, -1.0f, 1.0f);
        modelMatrix.method_22905(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.method_22904(0.0, (double)-1.501f, 0.0);
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
    }

    private void setupModelAnimations(float tickDelta) {
        class_2350 direction;
        float o;
        class_1297 class_12972;
        float h = class_3532.method_17821((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283);
        float j = class_3532.method_17821((float)tickDelta, (float)this.player.field_6259, (float)this.player.field_6241);
        float k = j - h;
        if (this.player.method_5765() && (class_12972 = this.player.method_5854()) instanceof class_1309) {
            class_1309 livingEntity2 = (class_1309)class_12972;
            h = class_3532.method_17821((float)tickDelta, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
            k = j - h;
            o = class_3532.method_15393((float)k);
            if (o < -85.0f) {
                o = -85.0f;
            }
            if (o >= 85.0f) {
                o = 85.0f;
            }
            h = j - o;
            if (o * o > 2500.0f) {
                h += o * 0.2f;
            }
            k = j - h;
        }
        float m = class_3532.method_16439((float)tickDelta, (float)this.player.field_6004, (float)this.player.method_36455());
        if (this.player.method_18376() == class_4050.field_18078 && (direction = this.player.method_18401()) != null) {
            float f = this.player.method_18381(class_4050.field_18076) - 0.1f;
        }
        o = tickDelta;
        float p = 0.0f;
        float q = 0.0f;
        if (!this.player.method_5765() && this.player.method_5805()) {
            p = this.player.field_42108.method_48570(tickDelta);
            o = this.player.field_42108.method_48572(tickDelta);
            if (this.player.method_6109()) {
                o *= 3.0f;
            }
            if (p > 1.0f) {
                p = 1.0f;
            }
        }
        this.model.field_3400 = this.player.method_18276();
        this.model.method_17087((class_1309)this.player, q, p, o, k, m);
    }

    public void translateAndRotate(Matrix4d transform, class_5603 pose) {
        transform.translate((double)(pose.field_27702 / 16.0f), (double)(pose.field_27703 / 16.0f), (double)(pose.field_27704 / 16.0f));
        if (pose.field_27707 != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationZ(pose.field_27707));
        }
        if (pose.field_27706 != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationY(pose.field_27706));
        }
        if (pose.field_27705 != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationX(pose.field_27705));
        }
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

